libname q 'c:\SASCodeforBook\SASDataSets';
	/*This SAS code provides the information presented in Figure 12.3 through Figure 12.6.*/
	/*The Difference in Differences (DID) estimators are calculated two ways: using the least
squares means estimate statement LSMestimate, and using the difference between the differences 
in the target and comparison groups.  The estimates from the LSMestimate statements are printed
out last and may be easier to follow than the DID estimators.  Of these, the first three 
comparisons focus on the treatment group, quantifying effects from: Time1 - Time0 (change in the
first period usually large and significant); Time2-Time0 (overall change, except for 4th grade
writing, not significant); Time2 - Time1(growth due to extra teachers, in target school not so 
large, in comparison schools large except for fourth grade writing which was unaffected by the
extra teachers in fifth grade,as hypothesized). The fouth of these comparisons focuses on change
in the comparison schools,Time2 - Time1.  This provides tests of significance for the odds ratios,
etc. for the comparison schools relative to the target schools.	These odds ratios are the 
reciprocal of those from the third of these comparisons.*/
	/*There are three DID estimators printed out: Time1 - Time0; Time2 - Time0; Time2 - Time1. 
These focus on change in the target group and the estimates should be the same as those using
the LSMestimate statements.	*/
	/*These results clearly show that the pattern for fourth grade writing tests differed
from those for mathematics, reading, and their average.  The extra teachers minimized the
differences between target and comparison schools in mathematics, reading, and their average
by the end of the evaluation period. However, these teachers did not directly affect the 
students' performance on the fourth grade writing tests.  Consequently, the two groups of 
schools differed across the evaluation period. Syntax by Robert B. Smith, copyright 2011*/

 
Data first; set q.HoustonSchools;

/*This code standardizes the covariates to mean zero*/

Title 'This codes standardizes the covariates by their mean';
   Proc standard data = first out= standard mean=0;
   var gpropensity3 sfal 
	higraddm frrdprob stratio mobility hispprob
	femprob maleprob blackprob lep;
Run;

Title 'This code provides a check that the means are zero';
   proc means data = standard;
   var gpropensity3 sfal 
    higraddm frrdprob stratio mobility hispprob
	femprob maleprob blackprob lep; 
run;

data standard; set standard;

/* The following code presents the LSMestimates and difference in differences estimates for 
	Figure 12.3 through Figure 12.6.  For reading, mathematics, the average of reading and 
	mathematics, and fourth grade writing.  The nuanced covariance structures are used in the
	models.	The effect sizes are discussed in the text*/	

Title 'Reading DID Effects, CS December 2010, Full Model, for Figure 12.3';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint ;
	Class school treatment period; 
	Model reading/denom = treatment period treatment*period 
	sfal Gpropensity3
	higraddm frrdprob stratio  mobility Hispprob
 	/ cl solution dist=binomial link=logit ;
	nloptions maxiter =50;
	random period / sub = school(treatment)  type = cs s residual vcorr;
	lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl; 
	lsmestimate treatment*period '(1,2-1,0) versus (0,2 - 0,0)'
		1  0 -1 -1 0 1 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,1) versus (0,2 - 0,1)'
		0  1 -1  0 -1 1 /or ilink cl;
	lsmestimate treatment*period'(0,2 - 0,1) versus (1,2 - 1,1)' 
		0 -1 1  0 1 -1  /or ilink cl; 

Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;
		
Title 'Math DID Effects, Toeplitz (2) December 2010, Figure 12.4';
	Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
	Class school treatment period;
	Model Math/denom = treatment period treatment*period  sfal gpropensity3
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ;
	nloptions maxiter =20;
	random period / sub = school (treatment) type = toep(2) s residual vcorr;
	lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,0) versus (0,2 - 0,0)'
		1  0 -1 -1 0 1 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,1) versus (0,2 - 0,1)'
		0  1 -1  0 -1 1 /or ilink cl;
	lsmestimate treatment*period'(0,2 - 0,1) versus (1,2 - 1,1)' 
		0 -1 1  0 1 -1  /or ilink cl; 

Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;

Title 'Ave.Math and Reading DID Effects, CS December 2010, Figure 12.5';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
	Class school treatment period;
	Model avemard/denom = treatment period treatment*period  gpropensity3 sfal
	higraddm frrdprob stratio mobility Hispprob
	/ cl solution dist=binomial link=logit ;
	nloptions maxiter =20;
	random period / sub = school(treatment)  type = cs residual vcorr;
	lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,0) versus (0,2 - 0,0)'
		1  0 -1 -1 0 1 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,1) versus (0,2 - 0,1)'
		0  1 -1  0 -1 1 /or ilink cl;
	lsmestimate treatment*period'(0,2 - 0,1) versus (1,2 - 1,1)' 
		0 -1 1  0 1 -1  /or ilink cl; 

Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
	run;

Title'G4Writing DID Effects, UN(1)Banded Main Diagonal, December 2010, Figure 12.6';
Proc Glimmix data = standard  method = rspl  ic=pq noitprint;
	Class school treatment period; 
	Model g4write/denom = treatment period treatment*period
	sfal Gpropensity3
	higraddm frrdprob stratio  mobility Hispprob
	/ cl solution dist=binomial link=logit ;
	nloptions maxiter =30;
	random period / sub = school(treatment)  type = un(1) s residual vcorr;
		lsmeans  treatment*period / odds ilink cl ;
	lsmestimate treatment*period '(1,1-1,0) versus (0,1 - 0,0)'
		1 -1 0  -1 1 0 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,0) versus (0,2 - 0,0)'
		1  0 -1 -1 0 1 /or ilink cl;
	lsmestimate treatment*period '(1,2-1,1) versus (0,2 - 0,1)'
		0  1 -1  0 -1 1 /or ilink cl;
	lsmestimate treatment*period'(0,2 - 0,1) versus (1,2 - 1,1)' 
		0 -1 1  0 1 -1  /or ilink cl; 

Title2 'Difference in differences estimator for first two time periods';
	*for the target group this estimates the difference between the means;
	estimate '1,1 - 1,0' period -1 1 0  treatment*period 0 0 0 -1 1 0 /or ilink cl;   
	*for the comparison group this estimates the difference between the means;
	estimate '0,1 - 0,0' period -1 1 0  treatment*period -1 1 0/or ilink cl;
	*this estimates the difference between the differences;
	estimate '(1,1-1,0) versus (0,1 - 0,0)' treatment*period 1 -1 0   -1 1 0 /or ilink cl;
Title3 'Difference in differences estimator for the third time period relative to the first';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,0' period -1 0 1  treatment*period 0 0 0 -1 0 1 /or ilink cl; 
	*this  gets the difference between means for the third time period relative to the first, null treatment;
	estimate '0,2 - 0,0' period -1 0 1  treatment*period -1 0 1 /or ilink cl; 
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,0) versus (0,2 - 0,0)' treatment*period 1 0 -1 -1 0 1/or ilink cl; 
Title4 'Difference in differences estimator for the third time period relative to the second';
	*for the target group this estimates the difference between the means;
	estimate '1,2 - 1,1' period 0 -1  1  treatment*period 0 0 0   0 -1  1 /or ilink cl;  
	*this gets the difference between means for the third time period relative to the second, null group;
	estimate '0,2 - 0,1' period 0 -1  1  treatment*period 0 -1  1 /or ilink cl;  
	*this estimates the difference between the two differences above;
	estimate '(1,2 - 1,1) versus (0,2 - 0,1)' treatment*period 0 1 -1  0 -1  1 /or ilink cl; 
run;


		/* This completes the code for Figures 9.3 to 9.6*/
		/* The syntax in this file is copyright by Robert B. Smith,  2011 */














































 
